/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientBlockItemTooltip
implements ClientTooltipComponent {
    private final ResourceLocation blockId;
    private final List<Component> components = Lists.newArrayList();
    @Nullable
    private MutableComponent packInfo;

    public ClientBlockItemTooltip(BlockItemTooltip tooltip) {
        this.blockId = tooltip.getBlockId();
        this.addText();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(this.blockId);
        if (packInfoObject != null) {
            this.packInfo = Component.m_237115_((String)packInfoObject.getName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);
        }
    }

    public int m_142103_() {
        return this.components.size() * 10 + (this.packInfo != null ? 16 : 0);
    }

    public int m_142069_(Font font) {
        int[] width = new int[]{0};
        if (this.packInfo != null) {
            width[0] = Math.max(width[0], font.m_92852_((FormattedText)this.packInfo) + 4);
        }
        this.components.forEach(c -> {
            width[0] = Math.max(width[0], font.m_92852_((FormattedText)c));
        });
        return width[0];
    }

    public void m_142440_(Font font, int pX, int pY, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int yOffset = pY;
        for (Component component : this.components) {
            font.m_272077_(component, (float)pX, (float)yOffset, 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.packInfo != null) {
            font.m_272077_((Component)this.packInfo, (float)pX, (float)(yOffset + 6), 0xFFFFFF, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics gui) {
    }

    private void addText() {
        TimelessAPI.getClientBlockIndex(this.blockId).ifPresent(index -> {
            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = I18n.m_118938_((String)tooltipKey, (Object[])new Object[0]);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> this.components.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.GRAY)));
            }
        });
    }
}

